  /*
   *  Object %name    : parser_atp_crys_sst_sym.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_crys_sst_sym.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/
#include "CRYS_SST_SEP_ATP_Sym.h"
#include "parser_atp_crys_sst_sym.h"
#include "sep_utils.h"
#include "SST_SEP_TST_DEFINES.h"

/************************ Global Data ************************/
extern DxByte_t*       TST_Workspace;
extern DxUint32_t      TST_WorkspaceSizeInBytes ;
extern DxUint8_t*      GlobalMemBuff;
extern DxUint8_t*      CurrGlobalMemBuff;
extern TST_ATP_PassAuthTestDataStruct* TST_ATP_PassAuthObjectTestData;

/******************** Private function  **********************/
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_HMAC
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return.
*
* Description:
* This function does the parsing for the external application SEPQA_CRYS_SST_HMAC
* function and calls the SEP function.
*
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_PARSER_CRYS_SST_HMAC(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;


    TST_Workspace = DX_NULL;

    /*1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                 &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }
    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));


      /*2. call QA SEP function */
     /***************************/
      SEP_Error = SEPQA_CRYS_SST_HMAC();
      SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_CRYS_SST_HMAC");
     

     /*3. end SEP message and return */
End:
    DX_VOS_MemFree(GlobalMemBuff);

    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_HMAC_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_DES
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_CRYS_SST_DES
* function and calls the SEP function.
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_CRYS_SST_DES(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;

    TST_Workspace = DX_NULL;

    /* call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                    &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));


      /* 2. call QA SEP function */
     /***************************/
    SEP_Error = SEPQA_CRYS_SST_DES();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_CRYS_SST_DES");

     /* 3. end SEP message and return */
End:
    DX_VOS_MemFree(GlobalMemBuff);

    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_DES_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_CRYS_SST_AES
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application SEPQA_CRYS_SST_AES
* function and calls the SEP function.
*
*
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_PARSER_CRYS_SST_AES(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;

    TST_Workspace = DX_NULL;

    /* call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                    &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }
    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_PassAuthObjectTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_PassAuthObjectTestData = (TST_ATP_PassAuthTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_PassAuthTestDataStruct);
    }

     /*4. extract parameters from the message*/
    DX_VOS_FastMemCpy(&TST_ATP_PassAuthObjectTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_PassAuthTestDataStruct));

      /* 2. call QA SEP function */
     /***************************/
      SEP_Error = SEPQA_CRYS_SST_AES();
      SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_CRYS_SST_AES");

     /* 3. end SEP message and return */
End:
    DX_VOS_MemFree(GlobalMemBuff);

    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_CRYS_SST_AES_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);
}
